<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use App\Http\Resources\SettingResource;

class SettingController extends Controller
{
    public function index()
    {
        $keys = ['phone', 'email', 'whatsapp', 'whatsapp_link', 'x_url', 'facebook_url',  'linkedin_url', 'instagram_url'];

        $settings = Setting::whereIn('key', $keys)->get();

        $keyed = $settings->pluck(null, 'key')->map(function ($setting) {
            if ($setting['url'] == 1 && !empty($setting['val'])) {
                return asset('storage/' . $setting['val']);
            }

            return $setting['val'];
        });

        return response()->json($keyed);
    }
}





