<?php
    use Illuminate\Support\Str;
?>

<?php $__env->startSection('title'); ?>
    Create <?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>

    <body data-sidebar="dark">
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('content'); ?>
        <?php $__env->startComponent('components.breadcrumb'); ?>
            <?php $__env->slot('page_title'); ?>
                Create <?php echo e($title); ?>

            <?php $__env->endSlot(); ?>
            <?php $__env->slot('subtitle'); ?>
                <a href="<?php echo e(route($routePath . '.index')); ?>"><?php echo e(Str::ucfirst(Str::plural($title))); ?></a>
            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>


        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="card-title">Create <?php echo e(Str::ucfirst($title)); ?></h4>
                        <p class="card-title-desc"></p>

                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route($routePath . '.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <!-- Name -->
                            <div class="mb-3">
                                <label>Title</label>
                                <input type="text" name="title" value="<?php echo e(old('title', $job->title ?? '')); ?>"
                                    class="form-control" required>
                            </div>

                            <div class="mb-3">
                                <label>Description</label>
                                <textarea name="description" class="form-control"><?php echo e(old('description', $job->description ?? '')); ?></textarea>
                            </div>

                            <div class="mb-3">
                                <label>Location</label>
                                <input type="text" name="location" value="<?php echo e(old('location', $job->location ?? '')); ?>"
                                    class="form-control">
                            </div>

                            <div class="mb-3">
                                <label>Department</label>
                                <input type="text" name="department"
                                    value="<?php echo e(old('department', $job->department ?? '')); ?>" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label>Type</label>
                                <select name="type" class="form-control">
                                    <?php $__currentLoopData = ['full-time', 'part-time', 'contract', 'internship']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type); ?>"
                                            <?php echo e(old('type', $job->type ?? '') == $type ? 'selected' : ''); ?>>
                                            <?php echo e(ucfirst($type)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label>Vacancies</label>
                                <input type="number" name="vacancies" value="<?php echo e(old('vacancies', $job->vacancies ?? 1)); ?>"
                                    class="form-control">
                            </div>

                            <div class="mb-3">
                                <label>Application Deadline</label>
                                <input type="date" name="application_deadline"
                                    value="<?php echo e(old('application_deadline', $job->application_deadline ?? '')); ?>"
                                    class="form-control">
                            </div>

                            <div class="form-check mb-3">
                                <input type="checkbox" name="active" value="1" class="form-check-input"
                                    <?php echo e(old('active', $job->active ?? true) ? 'checked' : ''); ?>>
                                <label class="form-check-label">Active</label>
                            </div>
                            ں

                            <button type="submit" class="btn btn-primary">Submit</button>

                        </form>

                    </div>
                </div>
            </div> <!-- end col -->
        </div> <!-- end row -->

    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>
        <script src="<?php echo e(URL::asset('assets/js/app.js')); ?>"></script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\joodfm_admin\resources\views/admin/jobs/create.blade.php ENDPATH**/ ?>