<?php $__env->startSection('title'); ?>
    Social Media Setting
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>

    <body data-sidebar="dark">
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('content'); ?>
        <?php $__env->startComponent('components.breadcrumb'); ?>
            <?php $__env->slot('page_title'); ?>
                Social Media Setting
            <?php $__env->endSlot(); ?>
            <?php $__env->slot('subtitle'); ?>
                <a href="<?php echo e(route('settings.index')); ?>">Setting</a>
            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>


        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="card-title">Social Media Setting</h4>
                        <p class="card-title-desc"></p>
                        <?php if(session('success')): ?>
                            <div class="alert alert-success" role="alert">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('settings.update', ['setting' => $settingId ?? 1])); ?>"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <input type="hidden" name="social_media_setting" value="1" />

                            

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="x_url">Twitter/X</label>
                                <div bis_skin_checked="1">
                                    <input type="url" class="form-control" name="x_url" id="x_url"
                                        value="<?php echo e(old('x_url', $settings['x_url'] ?? '')); ?>">
                                </div>
                            </div>

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="linkedin_url">Linkedin</label>
                                <div bis_skin_checked="1">
                                    <input type="url" class="form-control" name="linkedin_url" id="linkedin_url"
                                        value="<?php echo e(old('linkedin_url', $settings['linkedin_url'] ?? '')); ?>">
                                </div>
                            </div>

                            

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="instagram_url">Instagram</label>
                                <div bis_skin_checked="1">
                                    <input type="url" class="form-control" name="instagram_url" id="instagram_url"
                                        value="<?php echo e(old('instagram_url', $settings['instagram_url'] ?? '')); ?>">
                                </div>
                            </div>

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="instagram_url">Whatsapp</label>
                                <div bis_skin_checked="1">
                                    <input type="url" class="form-control" name="whatsapp_url" id="whatsapp_url"
                                        value="<?php echo e(old('whatsapp_url', $settings['whatsapp_url'] ?? '')); ?>">
                                </div>
                            </div>

                            <div class="col-12" bis_skin_checked="1">
                                <button class="btn btn-primary" type="submit">Save Setting</button>
                            </div>


                        </form>




                    </div>
                </div>

            </div> <!-- end col -->
        </div> <!-- end row -->
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>
        <script src="<?php echo e(URL::asset('assets/js/app.js')); ?>"></script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\joodfm_admin\resources\views/setting/social-media-settting.blade.php ENDPATH**/ ?>