<?php $__env->startSection('title'); ?> Profile <?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<link href="<?php echo e(URL::asset('assets/libs/magnific-popup/magnific-popup.min.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?> <body data-sidebar="dark"> <?php $__env->stopSection(); ?>
    <?php $__env->startSection('content'); ?>
    <?php $__env->startComponent('components.breadcrumb'); ?>
    <?php $__env->slot('page_title'); ?> Profile <?php $__env->endSlot(); ?>
    <?php $__env->slot('subtitle'); ?> Edit Profile <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <div class="row">
        <div class="col-xl-3">
            <div class="user-sidebar">
                <div class="card">
                    <div class="card-body pt-5">

                        <?php

                            $roles = $user->roles->pluck('name');

                        ?>

                        <div class="mt-n4 position-relative">
                            <div class="text-center">


                                <?php if(Auth::user()->profile_image): ?>
                                    <img src="<?php echo e(asset($user->profile_image)); ?>" alt="" class="avatar-xl rounded-circle img-thumbnail">
                                <?php else: ?>
                                    <img src="<?php echo e(URL::asset('assets/images/users/avatar-1.jpg')); ?>" alt="" class="avatar-xl rounded-circle img-thumbnail">
                                <?php endif; ?>


                                <div class="mt-3">
                                    <h5 class=""><?php echo e($user->name); ?></h5>
                                    <div>
                                        <a href="#" class="text-muted m-1"><?php echo e($roles[0]); ?></a>
                                    </div>


                                </div>

                            </div>
                        </div>



                    </div> <!-- end card body -->
                </div> <!-- end card -->


            </div>
        </div>

        <div class="col-xl-9">
            <div class="card">
                <div class="card-body">


                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(auth()->user()->hasRole('organization')): ?>

                        <form method="POST" action="<?php echo e(route('organizations.update', $record->id)); ?>" autocomplete="off" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <?php
                            print_r($record->organization);
                        ?>
                        <div class="row">
                                <div class="mb-3 col-md-4">
                                    <label>Name <span class="text-danger">*</span></label>
                                    <input type="text" name="organization_name" class="form-control" value="<?php echo e(old('organization_name', $record->name ?? '')); ?>" required>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label>Email <span class="text-danger">*</span></label>
                                    <input type="organization_email" name="organization_email" class="form-control" value="<?php echo e(old('organization_email', $record->email ?? '')); ?>" required>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label>Phone <span class="text-danger">*</span></label>
                                    <input type="text" name="organization_phone" class="form-control" value="<?php echo e(old('organization_phone', $record->phone ?? '')); ?>" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label>Address <span class="text-danger">*</span></label>
                                <input type="hidden" name="lat" id="latitude" value="<?php echo e(old('lat', $record->lat ?? '')); ?>">
                                <input type="hidden" name="long" id="longitude"  value="<?php echo e(old('long', $record->long ?? '')); ?>">
                                <input id="autocomplete" type="text" name="organization_address" class="form-control" value="<?php echo e(old('address', $record->address ?? '')); ?>" onFocus="geolocate()" required />
                            </div>

                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label>Zip Code</label>
                                    <input type="text" name="organization_zipcode" class="form-control" value="<?php echo e(old('organization_zipcode', $record->zipcode ?? '')); ?>">
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label>Website (https://xen-software.com)  <span class="text-danger">*</span></label>
                                    <input type="url" name="organization_website" class="form-control" value="<?php echo e(old('organization_website', $record->website ?? '')); ?>" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label>Logo</label>
                                <input type="file" name="organization_image" class="form-control">

                                <?php if($record->logo): ?>
                                    <div class="mt-2">
                                        <img src="<?php echo e(asset('storage/' . $record->logo)); ?>" alt="Logo" width="200">
                                    </div>
                                <?php endif; ?>
                            </div>

                            <hr>
                            <h4 class="card-title mb-4">Contact Information</h4>
                            <div class="row">
                                <div class="mb-3 col-md-4">
                                    <label>Full Name <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $record->user->name ?? '')); ?>" required>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label>Email <span class="text-danger">*</span></label>
                                    <input type="email" name="email" class="form-control" value="<?php echo e(old('email', $record->user->email ?? '')); ?>" readonly required>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label>Personal Contact # <span class="text-danger">*</span></label>
                                    <input type="text" name="phone" class="form-control" value="<?php echo e(old('phone', $record->contact_phone ?? '')); ?>" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label>Profile Image</label>
                                <input type="file" name="profile_image" class="form-control">
                                <?php if($record->user->profile_image): ?>
                                    <div class="mt-2">
                                        <img src="<?php echo e(asset('storage/' . $record->user->profile_image)); ?>" alt="Logo" width="200">
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label>Password  <span class="text-danger">*</span></label>
                                    <input type="text" name="password" class="form-control" >
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label>Confirm Password  <span class="text-danger">*</span></label>
                                    <input type="text" name="password_confirmation" class="form-control" >
                                </div>
                            </div>
                            <hr>



                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>

                    <?php else: ?>


                    <form  action="<?php echo e(route('profile.update')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('POST'); ?>

                    <div class="row">
                        <div class="mb-3 col-md-6" bis_skin_checked="1">
                            <label class="form-label" for="user_name">Name</label>
                            <div bis_skin_checked="1">
                                <input type="text" class="form-control" name="user_name" id="user_name" value="<?php echo e(old('user_name', $user->name ?? '')); ?>" required>
                            </div>
                        </div>

                        <div class="mb-3 col-md-6" bis_skin_checked="1">
                            <label class="form-label" for="admin_email">Email</label>
                            <div bis_skin_checked="1">
                                <input type="text" class="form-control" name="admin_email" id="admin_email" value="<?php echo e(old('admin_email', $user->email ?? '')); ?>" readonly>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="mb-3 col-md-6" bis_skin_checked="1">
                            <label for="password">Password</label>
                            <input type="password" class="form-control" id="password" name="password">
                        </div>

                        <div class="mb-3 col-md-6" bis_skin_checked="1">
                            <label for="password_confirmation">Confirm Password</label>
                            <input type="password" class="form-control" id="password_confirmation" name="password_confirmation">
                        </div>
                    </div>

                    <div class="mb-3" bis_skin_checked="1">
                        <label class="form-label" for="profile_image">Profile Image</label>
                        <input type="file" class="form-control" name="profile_image" id="profile_image" value="" >
                        
                    </div>


                    <div class="col-12" bis_skin_checked="1">
                        <button class="btn btn-primary" type="submit">Save</button>
                    </div>

                    </form>

                    <?php endif; ?>

                </div>
            </div>






        </div>
    </div>
    <!--end row-->

    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>

    <!-- Tour init js-->
    <script src="<?php echo e(URL::asset('assets/libs/apexcharts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/js/pages/profile.init.js')); ?>"></script>

    <script src="<?php echo e(URL::asset('assets/js/app.js')); ?>"></script>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\joodfm_admin\resources\views/profile-edit.blade.php ENDPATH**/ ?>